<?php
$configFile = __DIR__ . '/onedrive_config.json';

$config = file_exists($configFile)
    ? json_decode(file_get_contents($configFile), true)
    : [];

function v($arr, $key, $default = '') {
    return htmlspecialchars($arr[$key] ?? $default);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $config['auth'] = [
        'client_id'     => trim($_POST['client_id']),
        'client_secret' => trim($_POST['client_secret']),
        'tenant_id'     => trim($_POST['tenant_id']) ?: 'common',
        'redirect_uri'  => trim($_POST['redirect_uri'])
    ];

    $config['sync_policy'] = [
        'min_file_interval_seconds' => max(0, (int)$_POST['min_file_interval']),
        'min_run_interval_seconds'  => max(0, (int)$_POST['min_run_interval']),
        'max_files_per_run'         => max(1, (int)$_POST['max_files'])
    ];

    $config['local_storage'] = [
        'base_path'     => trim($_POST['base_path']),
        'overwrite'     => !empty($_POST['overwrite']),
        'temp_extension'=> trim($_POST['temp_extension']) ?: '.partial'
    ];

    $config['execution'] = [
        'lock_file'           => trim($_POST['lock_file']),
        'max_runtime_seconds' => max(30, (int)$_POST['max_runtime'])
    ];

    $config['error_policy'] = [
        'max_retries' => max(0, (int)$_POST['max_retries'])
    ];

    file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
    $saved = true;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>OneDrive Sync Setup</title>
    <style>
        body { font-family: sans-serif; max-width: 800px; margin: 40px auto; }
        h2 { margin-top: 30px; }
        label { display: block; margin: 8px 0; }
        input[type=text], input[type=number] {
            width: 100%; padding: 6px; box-sizing: border-box;
        }
        .box { background: #f5f5f5; padding: 15px; border-radius: 5px; }
        button { margin-top: 15px; padding: 10px 16px; background: #0078d4; color: #fff; border: none; border-radius: 4px; }
        .ok { background: #dff0d8; padding: 10px; margin-bottom: 15px; }
    </style>
</head>
<body>

<h1>OneDrive Sync – Setup</h1>

<?php if (!empty($saved)): ?>
    <div class="ok">Settings saved.</div>
<?php endif; ?>

<form method="post">

<div class="box">
<h2>Authentication</h2>
<label>Client ID <input type="text" name="client_id" value="<?= v($config['auth'] ?? [], 'client_id') ?>"></label>
<label>Client Secret <input type="text" name="client_secret" value="<?= v($config['auth'] ?? [], 'client_secret') ?>"></label>
<label>Tenant ID <input type="text" name="tenant_id" value="<?= v($config['auth'] ?? [], 'tenant_id', 'common') ?>"></label>
<label>Redirect URI <input type="text" name="redirect_uri" value="<?= v($config['auth'] ?? [], 'redirect_uri') ?>"></label>
</div>

<div class="box">
<h2>Sync Policy</h2>
<label>Min seconds between same file
<input type="number" name="min_file_interval" value="<?= v($config['sync_policy'] ?? [], 'min_file_interval_seconds', 300) ?>"></label>

<label>Min seconds between runs
<input type="number" name="min_run_interval" value="<?= v($config['sync_policy'] ?? [], 'min_run_interval_seconds', 60) ?>"></label>

<label>Max files per run
<input type="number" name="max_files" value="<?= v($config['sync_policy'] ?? [], 'max_files_per_run', 500) ?>"></label>
</div>

<div class="box">
<h2>Local Storage</h2>
<label>Base path
<input type="text" name="base_path" value="<?= v($config['local_storage'] ?? [], 'base_path', './synced_files') ?>"></label>

<label>
<input type="checkbox" name="overwrite" <?= !empty($config['local_storage']['overwrite']) ? 'checked' : '' ?>>
Allow overwrite
</label>

<label>Temp file extension
<input type="text" name="temp_extension" value="<?= v($config['local_storage'] ?? [], 'temp_extension', '.partial') ?>"></label>
</div>

<div class="box">
<h2>Execution & Safety</h2>
<label>Lock file
<input type="text" name="lock_file" value="<?= v($config['execution'] ?? [], 'lock_file', './sync.lock') ?>"></label>

<label>Max runtime (seconds)
<input type="number" name="max_runtime" value="<?= v($config['execution'] ?? [], 'max_runtime_seconds', 300) ?>"></label>

<label>Max retries
<input type="number" name="max_retries" value="<?= v($config['error_policy'] ?? [], 'max_retries', 3) ?>"></label>
</div>

<button type="submit">Save Setup</button>

</form>

</body>
</html>
